class Remmy extends xPawn;

var bool moveForward, moveBack, moveLeft, moveRight;
var float WallJumpSpeedZ, WallJumpSpeedFactor;
var Mesh SiriusMesh;
var Material SiriusHeadSkin, SiriusBodySkin, SiriusFrozenHeadSkin, SiriusFrozenBodySkin;
var class<xPawnSoundGroup> SiriusVoice;
var int RegenWaitTime;
var int LastDamageTime;
var class<Emitter> RegenEmitterClass;
var Emitter RegenEmitter;

function SetSiriusMesh()
{
	LinkMesh(SiriusMesh);
     Skins[0]=SiriusBodySkin;
     Skins[1]=SiriusHeadSkin;
	SoundGroupClass=SiriusVoice;
}

simulated function bool PointOfView()
{
	return true;
}

simulated function RawInput(float DeltaTime, float aBaseX, float aBaseY, float aBaseZ, float aMouseX, float aMouseY, float aForward, float aTurn, float aStrafe, float aUp, float aLookUp)
{
    moveForward = aForward > 0;
    moveBack = aForward < 0;
    moveLeft = aStrafe < 0;
    moveRight = aStrafe > 0;
}

function bool DoWallJump()
{
    local eDoubleClickDir DoubleClickMove;
    local vector X,Y,Z, TraceStart, TraceEnd, Dir, Cross, HitLocation, HitNormal;
    local Actor HitActor;
	local rotator TurnRot;

    DoubleClickMove = DCLICK_None;
    if(moveForward)
        DoubleClickMove = DCLICK_Back;
    else if(moveBack)
        DoubleClickMove = DCLICK_Forward;
    else if(moveLeft)
        DoubleClickMove = DCLICK_Right;
    else if(moveRight)
        DoubleClickMove = DCLICK_Left;

	TurnRot.Yaw = Rotation.Yaw;
    GetAxes(TurnRot,X,Y,Z);

		if ( !bCanWallDodge )
			return false;
        if (DoubleClickMove == DCLICK_Forward)
            TraceEnd = -X;
        else if (DoubleClickMove == DCLICK_Back)
            TraceEnd = X;
        else if (DoubleClickMove == DCLICK_Left)
            TraceEnd = Y;
        else if (DoubleClickMove == DCLICK_Right)
            TraceEnd = -Y;
        TraceStart = Location - CollisionHeight*Vect(0,0,1) + TraceEnd*CollisionRadius;
        TraceEnd = TraceStart + TraceEnd*32.0;
        HitActor = Trace(HitLocation, HitNormal, TraceEnd, TraceStart, false, vect(1,1,1));
        if ( (HitActor == None) || (!HitActor.bWorldGeometry && (Mover(HitActor) == None)) )
             return false;
    if (DoubleClickMove == DCLICK_Forward)
    {
		Dir = X;
		Cross = Y;
	}
    else if (DoubleClickMove == DCLICK_Back)
    {
		Dir = -1 * X;
		Cross = Y;
	}
    else if (DoubleClickMove == DCLICK_Left)
    {
		Dir = -1 * Y;
		Cross = X;
	}
    else if (DoubleClickMove == DCLICK_Right)
    {
		Dir = Y;
		Cross = X;
	}
	if ( AIController(Controller) != None )
		Cross = vect(0,0,0);
	PerformWallJump(DoubleClickMove, Dir,Cross);
	return true;
}

function bool PerformWallJump(eDoubleClickDir DoubleClickMove, vector Dir, vector Cross)
{
    local float VelocityZ;
    local name Anim;

    if ( Physics == PHYS_Falling )
    {
        if (DoubleClickMove == DCLICK_Forward)
            Anim = WallDodgeAnims[0];
        else if (DoubleClickMove == DCLICK_Back)
            Anim = WallDodgeAnims[1];
        else if (DoubleClickMove == DCLICK_Left)
            Anim = WallDodgeAnims[2];
        else if (DoubleClickMove == DCLICK_Right)
            Anim = WallDodgeAnims[3];

        if ( PlayAnim(Anim, 1.0, 0.1) )
            bWaitForAnim = true;
            AnimAction = Anim;
            
		TakeFallingDamage();
        if (Velocity.Z < -WallJumpSpeedZ*0.5)
			Velocity.Z += WallJumpSpeedZ*0.5;
    }

    VelocityZ = Velocity.Z;
    Velocity = WallJumpSpeedFactor*GroundSpeed*Dir + (Velocity Dot Cross)*Cross;

	if ( !bCanDodgeDoubleJump )
		MultiJumpRemaining = 0;
	if ( bCanBoostDodge || (Velocity.Z < -100) )
		Velocity.Z = VelocityZ + WallJumpSpeedZ;
	else
		Velocity.Z = WallJumpSpeedZ;

    CurrentDir = DoubleClickMove;
    SetPhysics(PHYS_Falling);
    PlayOwnedSound(GetSound(EST_Dodge), SLOT_Pain, GruntVolume,,80);
    return true;
}

function DoDoubleJump( bool bUpdating )
{
    local vector X,Y,Z,tempVel;
    local rotator TurnRot;
    PlayDoubleJump();

    if ( !bIsCrouched && !bWantsToCrouch )
    {
		if ( !IsLocallyControlled() || (AIController(Controller) != None) )
			MultiJumpRemaining -= 1;

        TurnRot.Yaw = Rotation.Yaw;
        GetAxes(TurnRot,X,Y,Z);

	if(moveForward || moveBack || moveLeft || moveRight)
	{
		Velocity.X = 0;
		Velocity.Y = 0;
		Velocity.Z = 0;
		if(moveForward)
			Velocity += GroundSpeed*X;
		if(moveBack)
			Velocity += GroundSpeed*-X;
		if(moveLeft)
			Velocity += GroundSpeed*-Y;
		if(moveRight)
			Velocity += GroundSpeed*Y;
	}
	else
	{
		Velocity.X = 0;
		Velocity.Y = 0;
		Velocity.Z = 0;
	}

	tempVel.X = Velocity.X;
	tempVel.Y = Velocity.Y;
	tempVel.Z = 0;

	if(VSize(tempVel) > GroundSpeed)
		Velocity = (GroundSpeed/VSize(tempVel))*tempVel;

        Velocity.Z = JumpZ + MultiJumpBoost;

        SetPhysics(PHYS_Falling);
        if ( !bUpdating )
			PlayOwnedSound(GetSound(EST_DoubleJump), SLOT_Pain, GruntVolume,,80);
    }
}

function bool DoJump( bool bUpdating )
{
    // This extra jump allows a jumping or dodging pawn to jump again mid-air
    // (via thrusters). The pawn must be within +/- 100 velocity units of the
    // apex of the jump to do this special move.
    if (!bUpdating && (Physics == PHYS_Falling) && DoWallJump() )
        return true;
    if ( !bUpdating && Super.CanDoubleJump()&& IsLocallyControlled() )
    {
		if ( PlayerController(Controller) != None )
			PlayerController(Controller).bDoubleJump = true;
        DoDoubleJump(bUpdating);
        MultiJumpRemaining -= 1;
        return true;
    }

    if ( Super.DoJump(bUpdating) )
    {
		if ( !bUpdating )
			PlayOwnedSound(GetSound(EST_Jump), SLOT_Pain, GruntVolume,,80);
        return true;
    }
    return false;
}

function bool Dodge(eDoubleClickDir DoubleClickMove)
{
    local vector X,Y,Z, Dir, Cross;
	local rotator TurnRot;

    if ( bIsCrouched || bWantsToCrouch || (Physics != PHYS_Falling) )
        return false;

	TurnRot.Yaw = Rotation.Yaw;
    GetAxes(TurnRot,X,Y,Z);

    if (DoubleClickMove == DCLICK_Forward)
    {
		Dir = X;
		Cross = Y;
	}
    else if (DoubleClickMove == DCLICK_Back)
    {
		Dir = -1 * X;
		Cross = Y;
	}
    else if (DoubleClickMove == DCLICK_Left)
    {
		Dir = -1 * Y;
		Cross = X;
	}
    else if (DoubleClickMove == DCLICK_Right)
    {
		Dir = Y;
		Cross = X;
	}
	if ( AIController(Controller) != None )
		Cross = vect(0,0,0);
	return PerformDodge(DoubleClickMove, Dir,Cross);
}

function bool PerformDodge(eDoubleClickDir DoubleClickMove, vector Dir, vector Cross)
{
    local float VelocityZ;
    local name Anim;

    if ( Physics != PHYS_Falling )
    {
        if (DoubleClickMove == DCLICK_Forward)
            Anim = WallDodgeAnims[0];
        else if (DoubleClickMove == DCLICK_Back)
            Anim = WallDodgeAnims[1];
        else if (DoubleClickMove == DCLICK_Left)
            Anim = WallDodgeAnims[2];
        else if (DoubleClickMove == DCLICK_Right)
            Anim = WallDodgeAnims[3];

        if ( PlayAnim(Anim, 1.0, 0.1) )
            bWaitForAnim = true;
            AnimAction = Anim;
            
		TakeFallingDamage();
        if (Velocity.Z < -DodgeSpeedZ*0.5)
			Velocity.Z += DodgeSpeedZ*0.5;
    }

    VelocityZ = Velocity.Z;
    Velocity = DodgeSpeedFactor*GroundSpeed*Dir + (Velocity Dot Cross)*Cross;

	if ( !bCanDodgeDoubleJump )
		MultiJumpRemaining = 0;
	if ( bCanBoostDodge || (Velocity.Z < -100) )
		Velocity.Z = VelocityZ + DodgeSpeedZ;
	else
		Velocity.Z = DodgeSpeedZ;

    CurrentDir = DoubleClickMove;
    SetPhysics(PHYS_Falling);
    PlayOwnedSound(GetSound(EST_Dodge), SLOT_Pain, GruntVolume,,80);
    return true;
}

simulated function FaceRotation( rotator NewRotation, float DeltaTime )
{
	if ( Physics == PHYS_Ladder )
		SetRotation(OnLadder.Walldir);
	else
	{
		//if ( (Physics == PHYS_Walking) || (Physics == PHYS_Falling) )
		//	NewRotation.Pitch = 0;
		SetRotation(NewRotation);
	}
}

function TakeFallingDamage()
{

}

function Died(Controller Killer, class<DamageType> damageType, vector HitLocation)
{
	local Trigger			T;
	local NavigationPoint	N;

	if ( bDeleteMe || Level.bLevelChange || Level.Game == None )
		return; // already destroyed, or level is being cleaned up

	if ( DamageType.default.bCausedByWorld && (Killer == None || Killer == Controller) && LastHitBy != None )
		Killer = LastHitBy;

	// mutator hook to prevent deaths
	// WARNING - don't prevent bot suicides - they suicide when really needed
	if ( Level.Game.PreventDeath(self, Killer, damageType, HitLocation) )
	{
		Health = max(Health, 1); //mutator should set this higher
		return;
	}
	Health = Min(0, Health);

	if ( DrivenVehicle != None )
	{
		Velocity = DrivenVehicle.Velocity;
		DrivenVehicle.DriverDied();
	}

	if ( Controller != None )
	{
		Controller.WasKilledBy(Killer);
		Level.Game.Killed(Killer, Controller, self, damageType);
	}
	else
		Level.Game.Killed(Killer, Controller(Owner), self, damageType);

	DrivenVehicle = None;

	if ( Killer != None )
		TriggerEvent(Event, self, Killer.Pawn);
	else
		TriggerEvent(Event, self, None);

	// make sure to untrigger any triggers requiring player touch
	if ( IsPlayerPawn() || WasPlayerPawn() )
	{
		PhysicsVolume.PlayerPawnDiedInVolume(self);
		ForEach TouchingActors(class'Trigger',T)
			T.PlayerToucherDied(self);

		// event for HoldObjectives
		//for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
		//	if ( N.bStatic && N.bReceivePlayerToucherDiedNotify )
		ForEach TouchingActors(class'NavigationPoint', N)
			if ( N.bReceivePlayerToucherDiedNotify )
				N.PlayerToucherDied( Self );
	}

	// remove powerup effects, etc.
	RemovePowerups();

	Velocity.Z *= 1.3;
	if ( IsHumanControlled() )
		PlayerController(Controller).ForceDeathUpdate();
    if ( (DamageType != None) && DamageType.default.bAlwaysGibs )
		ChunkUp( Rotation, DamageType.default.GibPerterbation );
	else
	{
		NetUpdateFrequency = Default.NetUpdateFrequency;
		PlayDying(DamageType, HitLocation);
		if ( Level.Game.bGameEnded )
			return;
		if ( !bPhysicsAnimUpdate && !IsLocallyControlled() )
			ClientDying(DamageType, HitLocation);
	}

}

simulated function PlayDyingAnimation(class<DamageType> DamageType, vector HitLoc)
{
	// non-ragdoll death fallback
	Velocity += TearOffMomentum;
    BaseEyeHeight = Default.BaseEyeHeight;
    SetTwistLook(0, 0);
    SetInvisibility(0.0);
    PlayDeathType(DamageType, HitLoc);
    SetPhysics(PHYS_Falling);
}

simulated function PlayDeathType(class<DamageType> DamageType, vector HitLoc)
{
    local Vector X,Y,Z, Dir;

	if(DamageType.name == 'FreezeDamType')
	{
		PlayAnim('Hit_Head');
		StopAnimating();
     		Skins[0]=SiriusFrozenBodySkin;
     		Skins[1]=SiriusFrozenHeadSkin;
		bFrozenBody=true;
	}
	else
	{
    GetAxes(Rotation, X,Y,Z);
    HitLoc.Z = Location.Z;

    // random
    if ( VSize(Velocity) < 10.0 && VSize(Location - HitLoc) < 1.0 )
    {
        Dir = VRand();
    }
    // velocity based
    else if ( VSize(Velocity) > 0.0 )
    {
        Dir = Normal(Velocity*Vect(1,1,0));
    }
    // hit location based
    else
    {
        Dir = -Normal(Location - HitLoc);
    }

    if ( Dir Dot X > 0.7 || Dir == vect(0,0,0))
        PlayAnim('DeathB',, 0.2);
    else if ( Dir Dot X < -0.7 )
         PlayAnim('DeathF',, 0.2);
    else if ( Dir Dot Y > 0 )
        PlayAnim('DeathL',, 0.2);
    else if ( HasAnim('DeathR') )
        PlayAnim('DeathR',, 0.2);
    else
        PlayAnim('DeathF',, 0.2);
	}
}

simulated function TakeDamage( int Damage, Pawn InstigatedBy, Vector Hitlocation, Vector Momentum, class<DamageType> damageType)
{
	LastDamageTime = Sirius(Level.Game).ElapsedTime;
	Super.TakeDamage(Damage, InstigatedBy, Hitlocation, Momentum, damageType);
}

simulated function Tick(float DeltaTime)
{
	if(Health > 0 && Health < default.HealthMax && Sirius(Level.Game).ElapsedTime - LastDamageTime >= RegenWaitTime)
	{
		if(RegenEmitter == None)
			RegenEmitter = spawn(RegenEmitterClass,,,self.Location);
		else
			RegenEmitter.SetLocation(self.Location);
		Health++;
	}
	else if(RegenEmitter != None)
		RegenEmitter.Destroy();
	Super.Tick(DeltaTime);
}

defaultproperties
{
	JumpZ = 540.000000
	MaxMultiJump=1
	bCanDodgeDoubleJump=true
	WallJumpSpeedZ=540
	WallJumpSpeedFactor=1.500000
	DodgeSpeedFactor=1.75
	PitchUpLimit=08000
	PitchDownLimit=59153
	SiriusMesh=SkeletalMesh'ZRemmy.Remmy'
	SiriusHeadSkin=Texture'ZSiriusSkins.Skins.RemmyFaceSkin'
	SiriusBodySkin=Texture'ZSiriusSkins.Skins.RemmyBodySkin'
	SiriusFrozenHeadSkin=Texture'ZSiriusSkins.Skins.RemmyFaceSkinFreeze'
	SiriusFrozenBodySkin=Texture'ZSiriusSkins.Skins.RemmyBodySkinFreeze'
	SiriusVoice=Class'XGame.xMercMaleSoundGroup'
	RequiredEquipment(0)="zwolf.FreezeRay"
	RequiredEquipment(1)=""
	ShieldStrengthMax=0
	HealthMax=100.000000
	SuperHealthMax=100.000000
	RegenWaitTime=15
	RegenEmitterClass=Class'zwolf.ShieldRecover'
}
